<?xml version="1.0" encoding="UTF-8"?><!--
 @package: Default Template V7 for SobiPro multi-directory component with content construction support

 @author
 Name: Sigrid Suski & Radek Suski, Sigsiu.NET GmbH
 Email: sobi[at]sigsiu.net
 Url: https://www.Sigsiu.NET

 @copyright Copyright (C) 2006-2023 Sigsiu.NET GmbH (https://www.sigsiu.net). All rights reserved.
 @license GNU/GPL Version 3
 This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License version 3
 as published by the Free Software Foundation, and under the additional terms according section 7 of GPL v3.
 See https://www.gnu.org/licenses/gpl.html and https://www.sigsiu.net/licenses.

 This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

 @modified 05 June 2023 by Sigrid Suski
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:php="http://php.net/xsl" exclude-result-prefixes="php">
	<xsl:output method="xml" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" encoding="UTF-8"/>

	<xsl:template name="editfield">
		<xsl:param name="fieldname"/>

		<xsl:if test="( name($fieldname) != 'save_button' ) and ( name($fieldname) != 'cancel_button' )">

			<!-- id of the field -->
			<xsl:variable name="fieldId" select="name($fieldname)"/>
			<!-- label width -->
			<xsl:variable name="lw">
				<xsl:choose>
					<xsl:when test="//config/columns-edit/@value = 'twocolumns'">
						<xsl:value-of select="//config/label-width-edit/@value"/>
					</xsl:when>
					<xsl:otherwise>12</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<!-- full content width -->
			<xsl:variable name="fcw">
				<xsl:value-of select="12 - number($lw)"/>
			</xsl:variable>
			<!-- content width -->
			<xsl:variable name="cw">
				<xsl:choose>
					<xsl:when test="//config/columns-edit/@value = 'twocolumns'">
						<xsl:choose>
							<xsl:when test="string-length( $fieldname/@width ) > 0">
								<xsl:choose>
									<xsl:when test="number($fieldname/@width) + number($lw) > 12">
										<xsl:value-of select="$fcw"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$fieldname/@width"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>{$fcw}</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="string-length( $fieldname/@width ) > 0">
								<xsl:value-of select="$fieldname/@width"/>
							</xsl:when>
							<xsl:otherwise>12</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<!-- column name and width -->
			<xsl:variable name="colname">
				<xsl:choose>
					<xsl:when test="$bs > 2">
						<xsl:text>col-</xsl:text>
						<xsl:if test="not(//config/grid-edit/@value = 'xs' and $bs > 3)">
							<xsl:value-of select="//config/grid-edit/@value"/>
							<xsl:text>-</xsl:text>
						</xsl:if>
					</xsl:when>
					<xsl:otherwise>span</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<!-- offset name and width -->
			<xsl:variable name="ofsname">
				<xsl:choose>
					<xsl:when test="$bs > 3">
						<xsl:text>offset-</xsl:text>
						<xsl:if test="not(//config/grid-edit/@value = 'xs' and $bs > 3)">
							<xsl:value-of select="//config/grid-edit/@value"/>
							<xsl:text>-</xsl:text>
						</xsl:if>
					</xsl:when>
					<xsl:when test="$bs = 3">
						<xsl:text>col-</xsl:text>
						<xsl:value-of select="//config/grid-edit/@value"/>
						<xsl:text>-offset-</xsl:text>
					</xsl:when>
					<xsl:otherwise>offset</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>


			<xsl:choose>

				<!-- Bootstrap 5 -->
				<xsl:when test="$bs = 5">
					<!-- which layout? -->
					<xsl:choose>
						<!-- 2 columns layout -->
						<xsl:when test="//config/columns-edit/@value = 'twocolumns'">

							<!-- overall container -->
							<div class="row {$fieldname/@css-edit} mb-4" id="{$fieldId}-container">
								<xsl:call-template name="development">
									<xsl:with-param name="fieldname" select="$fieldname"/>
								</xsl:call-template>

								<!-- payment box if not for free -->
								<xsl:if test="string-length( $fieldname/fee ) > 0 and not($fieldname/@data-meaning = 'price' or $fieldname/@data-meaning = 'terms')">
									<div class="{$colname}{$fcw} {$ofsname}{$lw}">
										<div class="form-check form-switch sp-paybox">
											<input name="{$fieldId}Payment" id="{$fieldId}-payment" value="" type="checkbox" class="spctrl-payment-box form-check-input"/>
											<label class="form-check-label" for="{$fieldId}-payment">
												<xsl:value-of select="$fieldname/fee_msg"/><xsl:text> </xsl:text>
												<xsl:value-of select="php:function( 'SobiPro::Txt', 'TP.PAYMENT_ADD' )"/>
											</label>
										</div>
									</div>
								</xsl:if>

								<!-- label if it should be shown -->
								<xsl:if test="$fieldname/label/@show = 1">
									<label class="{$colname}{$lw} col-form-label" for="{$fieldId}">
										<xsl:choose>
											<!-- if helptext as popover -->
											<xsl:when test="string-length( $fieldname/description ) and $fieldname/description/@position = 'popup'">
												<a href="#" rel="sp-popover" tabindex="0" data-bs-container="#SobiPro" data-bs-trigger="hover" data-bs-placement="top"
												   data-bs-content="{$fieldname/description}"
												   data-bs-title="{$fieldname/label}" data-bs-original-title="{$fieldname/label}">
													<xsl:value-of select="$fieldname/label"/>
												</a>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$fieldname/label"/>
											</xsl:otherwise>
										</xsl:choose>
										<!-- required star -->
										<xsl:if test="$fieldname/@required = 1 and //config/required-star/@value = 1">
											<sup>
												<span class="sp-star">
													<xsl:value-of select="php:function( 'SobiPro::Icon', 'star', $font )" disable-output-escaping="yes"/>
												</span>
												<span class="visually-hidden">
													<xsl:value-of select="php:function( 'SobiPro::Txt', 'ACCESSIBILITY.REQUIRED' )"/>
												</span>
											</sup>
										</xsl:if>
									</label>
								</xsl:if>

								<!-- help offset -->
								<xsl:variable name="helpoffset">
									<xsl:choose>
										<xsl:when test="$fieldname/label/@show = 0 and string-length( $fieldname/description ) > 0 and $fieldname/description/@position = 'above'">
											<xsl:value-of select="$ofsname"/><xsl:value-of select="$lw"/>
										</xsl:when>
									</xsl:choose>
								</xsl:variable>

								<!-- helptext (description) above (right of label) -->
								<xsl:if test="string-length( $fieldname/description ) and $fieldname/description/@position = 'above'">
									<div class="{$colname}{$fcw} {$helpoffset} form-text text-muted help-block above mb-1">
										<xsl:copy-of select="$fieldname/description/div"/>
									</div>
								</xsl:if>

								<!-- content offset -->
								<xsl:variable name="cob4">
									<xsl:choose>
										<xsl:when
												test="$fieldname/label/@show = 1 and not(string-length( $fieldname/description ) and $fieldname/description/@position = 'above')"/>
										<xsl:otherwise>
											<xsl:value-of select="$ofsname"/><xsl:value-of select="$lw"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>

								<!-- content element -->
								<div class="{$colname}{$cw} {$cob4}" id="{$fieldId}-input-container">
									<xsl:if test="contains($fieldname/@css-class,'spClassInfo')"> <!-- is info field -->
										<xsl:attribute name="data-role">
											<xsl:text>content</xsl:text>
										</xsl:attribute>
									</xsl:if>
									<xsl:if test="string-length( $fieldname/description ) > 0">
										<xsl:attribute name="aria-describedby">
											<xsl:value-of select="$fieldId"/><xsl:text>-helpblock</xsl:text>
										</xsl:attribute>
									</xsl:if>
									<xsl:choose>
										<xsl:when test="$fieldname/data/@escaped">
											<xsl:value-of select="$fieldname/data" disable-output-escaping="yes"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:copy-of select="$fieldname/data/*"/>
										</xsl:otherwise>
									</xsl:choose>
								</div>

								<!-- helptext (description) right -->
								<xsl:if test="string-length( $fieldname/description ) and $fieldname/description/@position = 'right'">
									<div class="{$colname}{number($fcw) - number($cw)} form-text text-muted help-block right">
										<xsl:copy-of select="$fieldname/description/div"/>
									</div>
								</xsl:if>

								<!-- error message container -->
								<div class="{$colname}{$fcw} {$ofsname}{$lw} feedback-container">
									<div id="{$fieldId}-message" class="invalid-feedback"/>
								</div>

								<!-- hint for admin fields -->
								<xsl:if test="$fieldname/@data-administrative = 1">
									<div class="{$colname}{$fcw} {$ofsname}{$lw} form-text text-muted help-block below administrative">
										<xsl:value-of select="php:function( 'SobiPro::Txt', 'TP.ADMINISTRATIVE', string($fieldname/label))"/>
									</div>
								</xsl:if>

								<!-- helptext (description) below -->
								<xsl:if test="string-length( $fieldname/description ) and $fieldname/description/@position = 'below'">
									<div class="{$colname}{$fcw} {$ofsname}{$lw} form-text text-muted help-block below">
										<xsl:copy-of select="$fieldname/description/div"/>
									</div>
								</xsl:if>
							</div>
						</xsl:when>


						<!-- one column (label above input) -->
						<xsl:otherwise>

							<!-- overall container -->
							<div class="row {$fieldname/@css-edit} mb-3" id="{$fieldId}-container">
								<xsl:call-template name="development">
									<xsl:with-param name="fieldname" select="$fieldname"/>
								</xsl:call-template>

								<!-- label if it should be shown -->
								<xsl:if test="$fieldname/label/@show = 1">
									<label class="{$colname}12 col-form-label" for="{$fieldId}">
										<xsl:choose>
											<!-- if helptext as popover -->
											<xsl:when test="string-length( $fieldname/description ) and $fieldname/description/@position = 'popup'">
												<a href="#" rel="sp-popover" tabindex="0" data-bs-container="#SobiPro" data-bs-trigger="hover" data-bs-placement="top"
												   data-bs-content="{$fieldname/description}"
												   data-bs-title="{$fieldname/label}" data-bs-original-title="{$fieldname/label}">
													<xsl:value-of select="$fieldname/label"/>
												</a>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$fieldname/label"/>
											</xsl:otherwise>
										</xsl:choose>
										<!-- required star -->
										<xsl:if test="$fieldname/@required = 1 and //config/required-star/@value = 1">
											<sup>
												<span class="sp-star">
													<xsl:value-of select="php:function( 'SobiPro::Icon', 'star', $font )" disable-output-escaping="yes"/>
												</span>
												<span class="visually-hidden">
													<xsl:value-of select="php:function( 'SobiPro::Txt', 'ACCESSIBILITY.REQUIRED' )"/>
												</span>
											</sup>
										</xsl:if>
									</label>
								</xsl:if>

								<!-- payment box if not for free -->
								<xsl:if test="string-length( $fieldname/fee ) > 0 and not(contains($fieldname/@css-edit, 'entryprice') and $fieldname/@type = 'chbxgroup' and $fieldname/@required = '1')">
									<div class="{$colname}12">
										<div class="form-check form-switch sp-paybox">
											<input name="{$fieldId}Payment" id="{$fieldId}-payment" value="" type="checkbox" class="spctrl-payment-box form-check-input"/>
											<label class="form-check-label" for="{$fieldId}-payment">
												<xsl:value-of select="$fieldname/fee_msg"/><xsl:text> </xsl:text>
												<xsl:value-of select="php:function( 'SobiPro::Txt', 'TP.PAYMENT_ADD' )"/>
											</label>
										</div>
									</div>
								</xsl:if>

								<!-- helptext (description) above -->
								<xsl:if test="string-length( $fieldname/description ) and $fieldname/description/@position = 'above'">
									<div class="{$colname}12 form-text text-muted help-block above mb-1" id="{$fieldId}-helpblock">
										<xsl:copy-of select="$fieldname/description/div"/>
									</div>
								</xsl:if>

								<!-- content element -->
								<div class="{$colname}{$cw}" id="{$fieldId}-input-container">
									<xsl:if test="contains($fieldname/@css-class,'spClassInfo')"> <!-- is info field -->
										<xsl:attribute name="data-role">
											<xsl:text>content</xsl:text>
										</xsl:attribute>
									</xsl:if>
									<xsl:if test="string-length( $fieldname/description ) > 0">
										<xsl:attribute name="aria-describedby">
											<xsl:value-of select="$fieldId"/><xsl:text>-helpblock</xsl:text>
										</xsl:attribute>
									</xsl:if>
									<xsl:choose>
										<xsl:when test="$fieldname/data/@escaped">
											<xsl:value-of select="$fieldname/data" disable-output-escaping="yes"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:copy-of select="$fieldname/data/*"/>
										</xsl:otherwise>
									</xsl:choose>
								</div>

								<!-- helptext (description) right -->
								<xsl:if test="string-length( $fieldname/description ) and $fieldname/description/@position = 'right'">
									<div class="{$colname}{12 - number($cw)} form-text text-muted help-block right" id="{$fieldId}-helpblock">
										<xsl:copy-of select="$fieldname/description/div"/>
									</div>
								</xsl:if>

								<!-- error message container -->
								<div class="{$colname}12 feedback-container">
									<div id="{$fieldId}-message" class="invalid-feedback"/>
								</div>

								<!-- hint for admin fields -->
								<xsl:if test="$fieldname/@data-administrative = 1">
									<div class="{$colname}12 form-text text-muted help-block below administrative">
										<xsl:value-of select="php:function( 'SobiPro::Txt', 'TP.ADMINISTRATIVE', string($fieldname/label))"/>
									</div>
								</xsl:if>

								<!-- helptext (description) below -->
								<xsl:if test="string-length( $fieldname/description ) and $fieldname/description/@position = 'below'">
									<div class="{$colname}12 form-text text-muted help-block below" id="{$fieldId}-helpblock">
										<xsl:copy-of select="$fieldname/description/div"/>
									</div>
								</xsl:if>
							</div>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>

				<!-- Bootstrap 4 -->
				<xsl:when test="$bs = 4">
					<!-- which layout? -->
					<xsl:choose>
						<!-- 2 columns layout -->
						<xsl:when test="//config/columns-edit/@value = 'twocolumns'">

							<!-- overall container -->
							<div class="mb-4 row {$fieldname/@css-edit}" id="{$fieldId}-container">
								<xsl:call-template name="development">
									<xsl:with-param name="fieldname" select="$fieldname"/>
								</xsl:call-template>

								<!-- payment box if not for free -->
								<xsl:if test="string-length( $fieldname/fee ) > 0 and not(contains($fieldname/@css-edit, 'entryprice') and $fieldname/@type = 'chbxgroup' and $fieldname/@required = '1')">
									<div class="{$colname}{$fcw} {$ofsname}{$lw}">
										<div class="custom-control custom-switch sp-paybox">
											<input name="{$fieldId}Payment" id="{$fieldId}-payment" value="" type="checkbox" class="spctrl-payment-box custom-control-input"/>
											<label class="custom-control-label" for="{$fieldId}-payment">
												<xsl:value-of select="$fieldname/fee_msg"/>
												<xsl:text/>
												<xsl:value-of select="php:function( 'SobiPro::Txt', 'TP.PAYMENT_ADD' )"/>
											</label>
										</div>
									</div>
								</xsl:if>

								<!-- label if it should be shown -->
								<xsl:if test="$fieldname/label/@show = 1">
									<label class="{$colname}{$lw} col-form-label" for="{$fieldId}">
										<xsl:choose>
											<!-- if helptext as popover -->
											<xsl:when test="string-length( $fieldname/description ) and $fieldname/description/@position = 'popup'">
												<a href="#" rel="sp-popover" tabindex="0" data-container="#SobiPro" data-trigger="hover" data-placement="top"
												   data-content="{$fieldname/description}"
												   data-title="{$fieldname/label}" data-original-title="{$fieldname/label}">
													<xsl:value-of select="$fieldname/label"/>
												</a>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$fieldname/label"/>
											</xsl:otherwise>
										</xsl:choose>
										<!-- required star -->
										<xsl:if test="$fieldname/@required = 1 and //config/required-star/@value = 1">
											<sup>
												<span class="sp-star">
													<xsl:value-of select="php:function( 'SobiPro::Icon', 'star', $font )" disable-output-escaping="yes"/>
												</span>
												<span class="sr-only">
													<xsl:value-of select="php:function( 'SobiPro::Txt', 'ACCESSIBILITY.REQUIRED' )"/>
												</span>
											</sup>
										</xsl:if>
									</label>
								</xsl:if>

								<!-- help offset -->
								<xsl:variable name="helpoffset">
									<xsl:choose>
										<xsl:when test="$fieldname/label/@show = 0 and string-length( $fieldname/description ) > 0 and $fieldname/description/@position = 'above'">
											<xsl:value-of select="$ofsname"/><xsl:value-of select="$lw"/>
										</xsl:when>
									</xsl:choose>
								</xsl:variable>

								<!-- helptext (description) above (right of label) -->
								<xsl:if test="string-length( $fieldname/description ) and $fieldname/description/@position = 'above'">
									<div class="{$colname}{$fcw} {$helpoffset} form-text text-muted help-block above mb-1">
										<xsl:copy-of select="$fieldname/description/div"/>
									</div>
								</xsl:if>

								<!-- content offset -->
								<xsl:variable name="cob4">
									<xsl:choose>
										<xsl:when
												test="$fieldname/label/@show = 1 and not(string-length( $fieldname/description ) and $fieldname/description/@position = 'above')"/>
										<xsl:otherwise>
											<xsl:value-of select="$ofsname"/>
											<xsl:value-of select="$lw"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>

								<!-- content element -->
								<div class="{$colname}{$cw} {$cob4}" id="{$fieldId}-input-container">
									<xsl:if test="contains($fieldname/@css-class,'spClassInfo')"> <!-- is info field -->
										<xsl:attribute name="data-role">
											<xsl:text>content</xsl:text>
										</xsl:attribute>
										<xsl:if test="string-length( $fieldname/description ) > 0">
											<xsl:attribute name="aria-describedby">
												<xsl:value-of select="$fieldId"/>
												<xsl:text>-helpblock</xsl:text>
											</xsl:attribute>
										</xsl:if>
									</xsl:if>
									<xsl:choose>
										<xsl:when test="$fieldname/data/@escaped">
											<xsl:value-of select="$fieldname/data" disable-output-escaping="yes"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:copy-of select="$fieldname/data/*"/>
										</xsl:otherwise>
									</xsl:choose>
								</div>

								<!-- helptext (description) right -->
								<xsl:if test="string-length( $fieldname/description ) and $fieldname/description/@position = 'right'">
									<div class="{$colname}{number($fcw) - number($cw)} form-text text-muted help-block right">
										<xsl:copy-of select="$fieldname/description/div"/>
									</div>
								</xsl:if>

								<!-- error message container -->
								<div class="{$colname}{$fcw} {$ofsname}{$lw} feedback-container">
									<div id="{$fieldId}-message" class="invalid-feedback"/>
								</div>

								<!-- hint for admin fields -->
								<xsl:if test="$fieldname/@data-administrative = 1">
									<div class="{$colname}{$fcw} {$ofsname}{$lw} form-text text-muted help-block below administrative">
										<xsl:value-of select="php:function( 'SobiPro::Txt', 'TP.ADMINISTRATIVE', string($fieldname/label))"/>
									</div>
								</xsl:if>

								<!-- helptext (description) below -->
								<xsl:if test="string-length( $fieldname/description ) and $fieldname/description/@position = 'below'">
									<div class="{$colname}{$fcw} {$ofsname}{$lw} form-text text-muted help-block below">
										<xsl:copy-of select="$fieldname/description/div"/>
									</div>
								</xsl:if>
							</div>
						</xsl:when>

						<!-- one column (label above input) -->
						<xsl:otherwise>

							<!-- overall container -->
							<div class="mb-3 row {$fieldname/@css-edit}" id="{$fieldId}-container">
								<xsl:call-template name="development">
									<xsl:with-param name="fieldname" select="$fieldname"/>
								</xsl:call-template>

								<!-- label if it should be shown -->
								<xsl:if test="$fieldname/label/@show = 1">
									<label class="{$colname}12 col-form-label" for="{$fieldId}">
										<xsl:choose>
											<!-- if helptext as popover -->
											<xsl:when test="string-length( $fieldname/description ) and $fieldname/description/@position = 'popup'">
												<a href="#" rel="sp-popover" tabindex="0" data-container="#SobiPro" data-trigger="hover" data-placement="top"
												   data-content="{$fieldname/description}"
												   data-title="{$fieldname/label}" data-original-title="{$fieldname/label}">
													<xsl:value-of select="$fieldname/label"/>
												</a>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$fieldname/label"/>
											</xsl:otherwise>
										</xsl:choose>
										<!-- required star -->
										<xsl:if test="$fieldname/@required = 1 and //config/required-star/@value = 1">
											<sup>
												<span class="sp-star">
													<xsl:value-of select="php:function( 'SobiPro::Icon', 'star', $font )" disable-output-escaping="yes"/>
												</span>
												<span class="sr-only">
													<xsl:value-of select="php:function( 'SobiPro::Txt', 'ACCESSIBILITY.REQUIRED' )"/>
												</span>
											</sup>
										</xsl:if>
									</label>
								</xsl:if>

								<!-- payment box if not for free -->
								<xsl:if test="string-length( $fieldname/fee ) > 0 and not($fieldname/@data-meaning = 'price' or $fieldname/@data-meaning = 'terms')">
									<div class="{$colname}12">
										<div class="custom-control custom-switch sp-paybox">
											<input name="{$fieldId}Payment" id="{$fieldId}-payment" value="" type="checkbox" class="spctrl-payment-box custom-control-input"/>
											<label class="custom-control-label" for="{$fieldId}-payment">
												<xsl:value-of select="$fieldname/fee_msg"/>
												<xsl:text></xsl:text>
												<xsl:value-of select="php:function( 'SobiPro::Txt', 'TP.PAYMENT_ADD' )"/>
											</label>
										</div>
									</div>
								</xsl:if>

								<!-- helptext (description) above (left of label) -->
								<xsl:if test="string-length( $fieldname/description ) and $fieldname/description/@position = 'above'">
									<div class="{$colname}12 form-text text-muted help-block above mb-1" id="{$fieldId}-helpblock">
										<xsl:copy-of select="$fieldname/description/div"/>
									</div>
								</xsl:if>

								<!-- content element -->
								<div class="{$colname}{$cw}" id="{$fieldId}-input-container">
									<xsl:if test="contains($fieldname/@css-class,'spClassInfo')"> <!-- is info field -->
										<xsl:attribute name="data-role">
											<xsl:text>content</xsl:text>
										</xsl:attribute>
									</xsl:if>
									<xsl:if test="string-length( $fieldname/description ) > 0">
										<xsl:attribute name="aria-describedby">
											<xsl:value-of select="$fieldId"/>
											<xsl:text>-helpblock</xsl:text>
										</xsl:attribute>
									</xsl:if>
									<xsl:choose>
										<xsl:when test="$fieldname/data/@escaped">
											<xsl:value-of select="$fieldname/data" disable-output-escaping="yes"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:copy-of select="$fieldname/data/*"/>
										</xsl:otherwise>
									</xsl:choose>
								</div>

								<!-- helptext (description) right -->
								<xsl:if test="string-length( $fieldname/description ) and $fieldname/description/@position = 'right'">
									<div class="{$colname}{12 - number($cw)} form-text text-muted help-block right" id="{$fieldId}-helpblock">
										<xsl:copy-of select="$fieldname/description/div"/>
									</div>
								</xsl:if>

								<!-- error message container -->
								<div class="{$colname}12 feedback-container">
									<div id="{$fieldId}-message" class="invalid-feedback"/>
								</div>

								<!-- hint for admin fields -->
								<xsl:if test="$fieldname/@data-administrative = 1">
									<div class="{$colname}12 form-text text-muted help-block below administrative">
										<xsl:value-of select="php:function( 'SobiPro::Txt', 'TP.ADMINISTRATIVE', string($fieldname/label))"/>
									</div>
								</xsl:if>

								<!-- helptext (description) below -->
								<xsl:if test="string-length( $fieldname/description ) and $fieldname/description/@position = 'below'">
									<div class="{$colname}12 form-text text-muted help-block below" id="{$fieldId}-helpblock">
										<xsl:copy-of select="$fieldname/description/div"/>
									</div>
								</xsl:if>
							</div>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>

				<!-- Bootstrap 3 -->
				<xsl:when test="$bs = 3">
					<xsl:choose>
						<!-- 2 columns layout -->
						<xsl:when test="//config/columns-edit/@value = 'twocolumns'">

							<!-- overall container -->
							<div class="mb-4 form-group {$fieldname/@css-edit}" id="{$fieldId}-container">
								<xsl:call-template name="development">
									<xsl:with-param name="fieldname" select="$fieldname"/>
								</xsl:call-template>

								<!-- payment box if not for free -->
								<xsl:if test="string-length( $fieldname/fee ) > 0 and not($fieldname/@data-meaning = 'price' or $fieldname/@data-meaning = 'terms')">
									<div class="{$colname}{$fcw} {$ofsname}{$lw}">
										<div class="sp-paybox">
											<label class="control-label {$colname}{$fcw}" for="{$fieldId}-payment">
												<input name="{$fieldId}Payment" id="{$fieldId}-payment" value="" type="checkbox" class="spctrl-payment-box"/>
												<xsl:value-of select="$fieldname/fee_msg"/>
												<xsl:text></xsl:text>
												<xsl:value-of select="php:function( 'SobiPro::Txt', 'TP.PAYMENT_ADD' )"/>
											</label>
										</div>
									</div>
								</xsl:if>

								<!-- label if it should be shown -->
								<xsl:if test="$fieldname/label/@show = 1">
									<label class="{$colname}{$lw} control-label" for="{$fieldId}">
										<xsl:choose>
											<!-- if helptext as popover -->
											<xsl:when test="string-length( $fieldname/description ) and $fieldname/description/@position = 'popup'">
												<a href="#" rel="sp-popover" tabindex="0" data-container="#SobiPro" data-trigger="hover" data-placement="top"
												   data-content="{$fieldname/description}"
												   data-title="{$fieldname/label}" data-original-title="{$fieldname/label}">
													<xsl:value-of select="$fieldname/label"/>
												</a>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$fieldname/label"/>
											</xsl:otherwise>
										</xsl:choose>
										<!-- required star -->
										<xsl:if test="$fieldname/@required = 1 and //config/required-star/@value = 1">
											<sup>
												<span class="sp-star">
													<xsl:value-of select="php:function( 'SobiPro::Icon', 'star', $font )" disable-output-escaping="yes"/>
												</span>
												<span class="sr-only">
													<xsl:value-of select="php:function( 'SobiPro::Txt', 'ACCESSIBILITY.REQUIRED' )"/>
												</span>
											</sup>
										</xsl:if>
									</label>
								</xsl:if>

								<!-- help offset -->
								<xsl:variable name="helpoffset">
									<xsl:choose>
										<xsl:when test="$fieldname/label/@show = 0 and string-length( $fieldname/description ) > 0 and $fieldname/description/@position = 'above'"
										>
											<xsl:value-of select="$ofsname"/><xsl:value-of select="$lw"/>
										</xsl:when>
									</xsl:choose>
								</xsl:variable>

								<!-- helptext (description) above (right of label) -->
								<xsl:if test="string-length( $fieldname/description ) and $fieldname/description/@position = 'above'">
									<div class="{$colname}{$fcw}  {$helpoffset}help-block above mb-1">
										<xsl:copy-of select="$fieldname/description/div"/>
									</div>
									<div class="clearfix"/>
								</xsl:if>

								<!-- content offset -->
								<xsl:variable name="cob3">
									<xsl:choose>
										<xsl:when
												test="$fieldname/label/@show = 1 and not(string-length( $fieldname/description ) and $fieldname/description/@position = 'above')"/>
										<xsl:otherwise>
											<xsl:value-of select="$ofsname"/>
											<xsl:value-of select="$lw"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>

								<!-- content element -->
								<div class="{$colname}{$cw} {$cob3}" id="{$fieldId}-input-container">
									<xsl:if test="contains($fieldname/@css-class,'spClassInfo')"> <!-- is info field -->
										<xsl:attribute name="data-role">
											<xsl:text>content</xsl:text>
										</xsl:attribute>
										<xsl:if test="string-length( $fieldname/description ) > 0">
											<xsl:attribute name="aria-describedby">
												<xsl:value-of select="$fieldId"/>
												<xsl:text>-helpblock</xsl:text>
											</xsl:attribute>
										</xsl:if>
									</xsl:if>
									<xsl:choose>
										<xsl:when test="$fieldname/data/@escaped">
											<xsl:value-of select="$fieldname/data" disable-output-escaping="yes"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:copy-of select="$fieldname/data/*"/>
										</xsl:otherwise>
									</xsl:choose>
								</div>

								<!-- helptext (description) right -->
								<xsl:if test="string-length( $fieldname/description ) and $fieldname/description/@position = 'right'">
									<div class="{$colname}{number($fcw) - number($cw)} help-block right">
										<xsl:copy-of select="$fieldname/description/div"/>
									</div>
								</xsl:if>

								<!-- error message container -->
								<div class="{$colname}{$fcw} {$ofsname}{$lw} feedback-container clearfix">
									<div id="{$fieldId}-message" class="invalid-feedback"/>
								</div>

								<!-- hint for admin fields -->
								<xsl:if test="$fieldname/@data-administrative = 1">
									<div class="{$colname}{$fcw} {$ofsname}{$lw} help-block below administrative">
										<xsl:value-of select="php:function( 'SobiPro::Txt', 'TP.ADMINISTRATIVE', string($fieldname/label))"/>
									</div>
								</xsl:if>

								<!-- helptext (description) below -->
								<xsl:if test="string-length( $fieldname/description ) and $fieldname/description/@position = 'below'">
									<div class="{$colname}{$fcw} {$ofsname}{$lw} help-block below">
										<xsl:copy-of select="$fieldname/description/div"/>
									</div>
								</xsl:if>
							</div>
						</xsl:when>

						<!-- one column (label above input) -->
						<xsl:otherwise>

							<!-- overall container -->
							<div class="mb-3 fom-group clearfix {$fieldname/@css-edit}" id="{$fieldId}-container">
								<xsl:call-template name="development">
									<xsl:with-param name="fieldname" select="$fieldname"/>
								</xsl:call-template>

								<!-- label if it should be shown -->
								<xsl:if test="$fieldname/label/@show = 1">
									<label class="{$colname}12 control-label" for="{$fieldId}">
										<xsl:choose>
											<xsl:when test="string-length( $fieldname/description ) and $fieldname/description/@position = 'popup'">
												<a href="#" rel="sp-popover" tabindex="0" data-container="#SobiPro" data-trigger="hover" data-placement="top"
												   data-content="{$fieldname/description}"
												   data-title="{$fieldname/label}" data-original-title="{$fieldname/label}">
													<xsl:value-of select="$fieldname/label"/>
												</a>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$fieldname/label"/>
											</xsl:otherwise>
										</xsl:choose>
										<xsl:if test="$fieldname/@required = 1 and //config/required-star/@value = 1">
											<sup>
												<span class="sp-star">
													<xsl:value-of select="php:function( 'SobiPro::Icon', 'star', $font )" disable-output-escaping="yes"/>
												</span>
												<span class="sr-only">
													<xsl:value-of select="php:function( 'SobiPro::Txt', 'ACCESSIBILITY.REQUIRED' )"/>
												</span>
											</sup>
										</xsl:if>
									</label>
								</xsl:if>
								<!-- payment box if not for free -->
								<xsl:if test="string-length( $fieldname/fee ) > 0 and not($fieldname/@data-meaning = 'price' or $fieldname/@data-meaning = 'terms')">
									<div class="{$colname}12">
										<div class="sp-paybox">
											<label class="control-label" for="{$fieldId}-payment">
												<input name="{$fieldId}Payment" id="{$fieldId}-payment" value="" type="checkbox" class="spctrl-payment-box"/>
												<xsl:value-of select="$fieldname/fee_msg"/>
												<xsl:text></xsl:text>
												<xsl:value-of select="php:function( 'SobiPro::Txt', 'TP.PAYMENT_ADD' )"/>
											</label>
										</div>
									</div>
								</xsl:if>

								<!-- helptext (description) above -->
								<xsl:if test="string-length( $fieldname/description ) and $fieldname/description/@position = 'above'">
									<div class="{$colname}12 help-block above mb-1" id="{$fieldId}-helpblock">
										<xsl:copy-of select="$fieldname/description/div"/>
									</div>
								</xsl:if>

								<!-- content element -->
								<div class="{$colname}{$cw}" id="{$fieldId}-input-container">
									<xsl:if test="contains($fieldname/@css-class,'spClassInfo')"> <!-- is info field -->
										<xsl:attribute name="data-role">
											<xsl:text>content</xsl:text>
										</xsl:attribute>
									</xsl:if>
									<xsl:if test="string-length( $fieldname/description ) > 0">
										<xsl:attribute name="aria-describedby">
											<xsl:value-of select="$fieldId"/>
											<xsl:text>-helpblock</xsl:text>
										</xsl:attribute>
									</xsl:if>
									<xsl:choose>
										<xsl:when test="$fieldname/data/@escaped">
											<xsl:value-of select="$fieldname/data" disable-output-escaping="yes"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:copy-of select="$fieldname/data/*"/>
										</xsl:otherwise>
									</xsl:choose>
								</div>

								<!-- helptext (description) right -->
								<xsl:if test="string-length( $fieldname/description ) and $fieldname/description/@position = 'right'">
									<div class="{$colname}{12 - number($cw)} help-block right" id="{$fieldId}-helpblock">
										<xsl:copy-of select="$fieldname/description/div"/>
									</div>
								</xsl:if>

								<!-- error message container -->
								<div class="{$colname}12 feedback-container clearfix">
									<div id="{$fieldId}-message" class="invalid-feedback"/>
								</div>

								<!-- hint for admin fields -->
								<xsl:if test="$fieldname/@data-administrative = 1">
									<div class="{$colname}12 help-block below administrative">
										<xsl:value-of select="php:function( 'SobiPro::Txt', 'TP.ADMINISTRATIVE', string($fieldname/label))"/>
									</div>
								</xsl:if>

								<!-- helptext (description) below -->
								<xsl:if test="string-length( $fieldname/description ) and $fieldname/description/@position = 'below'">
									<div class="{$colname}12 help-block below" id="{$fieldId}-helpblock">
										<xsl:copy-of select="$fieldname/description/div"/>
									</div>
								</xsl:if>
							</div>

						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>

				<!-- Bootstrap 2 -->
				<xsl:otherwise>
					<xsl:choose>
						<!-- 2 columns layout -->
						<xsl:when test="//config/columns-edit/@value = 'twocolumns'">

							<!-- overall container -->
							<div class="mb-4 control-group row-fluid {$fieldname/@css-edit}" id="{$fieldId}-container">
								<xsl:call-template name="development">
									<xsl:with-param name="fieldname" select="$fieldname"/>
								</xsl:call-template>

								<!-- payment box if not for free -->
								<xsl:if test="string-length( $fieldname/fee ) > 0 and not($fieldname/@data-meaning = 'price' or $fieldname/@data-meaning = 'terms')">
									<div class="{$colname}{$fcw} {$ofsname}{$lw}">
										<div class="sp-paybox">
											<label class="checkbox" for="{$fieldId}-payment">
												<input name="{$fieldId}Payment" id="{$fieldId}-payment" value="" type="checkbox" class="spctrl-payment-box"/>
												<xsl:value-of select="$fieldname/fee_msg"/>
												<xsl:text/>
												<xsl:value-of select="php:function( 'SobiPro::Txt', 'TP.PAYMENT_ADD' )"/>
											</label>
										</div>
									</div>
									<div class="clearfix"/>
								</xsl:if>

								<!-- label if it should be shown -->
								<xsl:if test="$fieldname/label/@show = 1">
									<label class="{$colname}{$lw} ms-0 control-label" for="{$fieldId}">
										<xsl:choose>
											<!-- if helptext as popover -->
											<xsl:when test="string-length( $fieldname/description ) and $fieldname/description/@position = 'popup'">
												<a href="#" rel="sp-popover" tabindex="0" data-toggle="popover" data-container="#{$fieldId}-input-container" data-trigger="hover"
												   data-placement="right"
												   data-content="{$fieldname/description}"
												   data-title="{$fieldname/label}" data-original-title="{$fieldname/label}">
													<xsl:value-of select="$fieldname/label"/>
												</a>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$fieldname/label"/>
											</xsl:otherwise>
										</xsl:choose>
										<!-- required star -->
										<xsl:if test="$fieldname/@required = 1 and //config/required-star/@value = 1">
											<sup>
												<span class="sp-star">
													<xsl:value-of select="php:function( 'SobiPro::Icon', 'star', $font )" disable-output-escaping="yes"/>
												</span>
												<span class="sr-only">
													<xsl:value-of select="php:function( 'SobiPro::Txt', 'ACCESSIBILITY.REQUIRED' )"/>
												</span>
											</sup>
										</xsl:if>
									</label>
								</xsl:if>

								<!-- help offset -->
								<xsl:variable name="helpoffset">
									<xsl:choose>
										<xsl:when test="$fieldname/label/@show = 0 and string-length( $fieldname/description ) > 0 and $fieldname/description/@position = 'above'">
											<xsl:value-of select="$ofsname"/><xsl:value-of select="$lw"/>
										</xsl:when>
									</xsl:choose>
								</xsl:variable>

								<!-- helptext (description) above (right of label) -->
								<xsl:if test="string-length( $fieldname/description ) and $fieldname/description/@position = 'above'">
									<div class="{$colname}{$fcw} {$helpoffset} help-block above mb-1">
										<xsl:copy-of select="$fieldname/description/div"/>
									</div>
									<div class="clearfix"/>
								</xsl:if>

								<!-- content offset -->
								<xsl:variable name="cob3">
									<xsl:choose>
										<xsl:when
												test="$fieldname/label/@show = 1 and not(string-length( $fieldname/description ) and $fieldname/description/@position = 'above')"/>
										<xsl:otherwise>
											<xsl:value-of select="$ofsname"/>
											<xsl:value-of select="$lw"/>
											<xsl:text> no-margin</xsl:text>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>

								<!-- content element -->
								<div class="{$colname}{$cw} {$cob3}" id="{$fieldId}-input-container">
									<xsl:if test="contains($fieldname/@css-class,'spClassInfo')"> <!-- is info field -->
										<xsl:attribute name="data-role">
											<xsl:text>content</xsl:text>
										</xsl:attribute>
										<xsl:if test="string-length( $fieldname/description ) > 0">
											<xsl:attribute name="aria-describedby">
												<xsl:value-of select="$fieldId"/>
												<xsl:text>-helpblock</xsl:text>
											</xsl:attribute>
										</xsl:if>
									</xsl:if>
									<xsl:choose>
										<xsl:when test="$fieldname/data/@escaped">
											<xsl:value-of select="$fieldname/data" disable-output-escaping="yes"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:copy-of select="$fieldname/data/*"/>
										</xsl:otherwise>
									</xsl:choose>
								</div>

								<!-- helptext (description) right -->
								<xsl:choose>
									<xsl:when test="string-length( $fieldname/description ) and $fieldname/description/@position = 'right'">
										<div class="{$colname}{number($fcw) - number($cw)} ms-0 help-block right">
											<xsl:copy-of select="$fieldname/description/div"/>
										</div>
										<div class="clearfix"/>
									</xsl:when>
									<xsl:otherwise>
										<div class="clearfix"/>
									</xsl:otherwise>
								</xsl:choose>

								<!-- error message container -->
								<div class="{$colname}{$fcw} {$ofsname}{$lw} feedback-container">
									<div id="{$fieldId}-message" class="invalid-feedback"/>
								</div>
								<div class="clearfix"/>

								<!-- hint for admin fields -->
								<xsl:if test="$fieldname/@data-administrative = 1">
									<div class="{$colname}{$fcw} {$ofsname}{$lw} help-block below administrative">
										<xsl:value-of select="php:function( 'SobiPro::Txt', 'TP.ADMINISTRATIVE', string($fieldname/label))"/>
									</div>
									<div class="clearfix"/>
								</xsl:if>

								<!-- helptext (description) below -->
								<xsl:if test="string-length( $fieldname/description ) and $fieldname/description/@position = 'below'">
									<div class="{$colname}{$fcw} {$ofsname}{$lw} help-block below">
										<xsl:copy-of select="$fieldname/description/div"/>
									</div>
									<div class="clearfix"/>
								</xsl:if>
							</div>
							<div class="clearfix"/>
						</xsl:when>

						<!-- one column (label above input) -->
						<xsl:otherwise>

							<!-- overall container -->
							<div class="mb-3 fom-group {$fieldname/@css-edit}" id="{$fieldId}-container">
								<xsl:call-template name="development">
									<xsl:with-param name="fieldname" select="$fieldname"/>
								</xsl:call-template>

								<!-- label if it should be shown -->
								<xsl:if test="$fieldname/label/@show = 1">
									<label class="{$colname}12 control-label" for="{$fieldId}">
										<xsl:choose>
											<xsl:when test="string-length( $fieldname/description ) and $fieldname/description/@position = 'popup'">
												<a href="#" rel="sp-popover" tabindex="0" data-container="#SobiPro" data-trigger="hover" data-placement="right"
												   data-content="{$fieldname/description}"
												   data-title="{$fieldname/label}" data-original-title="{$fieldname/label}">
													<xsl:value-of select="$fieldname/label"/>
												</a>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$fieldname/label"/>
											</xsl:otherwise>
										</xsl:choose>
										<xsl:if test="$fieldname/@required = 1 and //config/required-star/@value = 1">
											<sup>
												<span class="sp-star">
													<xsl:value-of select="php:function( 'SobiPro::Icon', 'star', $font )" disable-output-escaping="yes"/>
												</span>
												<span class="sr-only">
													<xsl:value-of select="php:function( 'SobiPro::Txt', 'ACCESSIBILITY.REQUIRED' )"/>
												</span>
											</sup>
										</xsl:if>
									</label>
									<div class="clearfix"/>
								</xsl:if>
								<!-- payment box if not for free -->
								<xsl:if test="string-length( $fieldname/fee ) > 0 and not($fieldname/@data-meaning = 'price' or $fieldname/@data-meaning = 'terms')">
									<div class="{$colname}12">
										<div class="sp-paybox">
											<label class="control-label" for="{$fieldId}-payment">
												<input name="{$fieldId}Payment" id="{$fieldId}-payment" value="" type="checkbox" class="spctrl-payment-box"/>
												<xsl:value-of select="$fieldname/fee_msg"/>
												<xsl:text></xsl:text>
												<xsl:value-of select="php:function( 'SobiPro::Txt', 'TP.PAYMENT_ADD' )"/>
											</label>
										</div>
									</div>
									<div class="clearfix"/>
								</xsl:if>

								<!-- helptext (description) above -->
								<xsl:if test="string-length( $fieldname/description ) and $fieldname/description/@position = 'above'">
									<div class="{$colname}12 help-block above mb-1" id="{$fieldId}-helpblock">
										<xsl:copy-of select="$fieldname/description/div"/>
									</div>
									<div class="clearfix"/>
								</xsl:if>

								<!-- content element -->
								<div class="{$colname}{$cw}" id="{$fieldId}-input-container">
									<xsl:if test="contains($fieldname/@css-class,'spClassInfo')"> <!-- is info field -->
										<xsl:attribute name="data-role">
											<xsl:text>content</xsl:text>
										</xsl:attribute>
									</xsl:if>
									<xsl:if test="string-length( $fieldname/description ) > 0">
										<xsl:attribute name="aria-describedby">
											<xsl:value-of select="$fieldId"/>
											<xsl:text>-helpblock</xsl:text>
										</xsl:attribute>
									</xsl:if>
									<xsl:choose>
										<xsl:when test="$fieldname/data/@escaped">
											<xsl:value-of select="$fieldname/data" disable-output-escaping="yes"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:copy-of select="$fieldname/data/*"/>
										</xsl:otherwise>
									</xsl:choose>
								</div>

								<!-- helptext (description) right -->
								<xsl:choose>
									<xsl:when test="string-length( $fieldname/description ) and $fieldname/description/@position = 'right'">
										<div class="{$colname}{12 - number($cw)} help-block right" id="{$fieldId}-helpblock">
											<xsl:copy-of select="$fieldname/description/div"/>
										</div>
										<div class="clearfix"/>
									</xsl:when>
									<xsl:otherwise>
										<div class="clearfix"/>
									</xsl:otherwise>
								</xsl:choose>

								<!-- error message container -->
								<div class="{$colname}12 feedback-container">
									<div id="{$fieldId}-message" class="invalid-feedback"/>
								</div>
								<div class="clearfix"/>

								<!-- hint for admin fields -->
								<xsl:if test="$fieldname/@data-administrative = 1">
									<div class="{$colname}12 help-block below administrative">
										<xsl:value-of select="php:function( 'SobiPro::Txt', 'TP.ADMINISTRATIVE', string($fieldname/label))"/>
									</div>
									<div class="clearfix"/>
								</xsl:if>

								<!-- helptext (description) below -->
								<xsl:if test="string-length( $fieldname/description ) and $fieldname/description/@position = 'below'">
									<div class="{$colname}12 help-block below" id="{$fieldId}-helpblock">
										<xsl:copy-of select="$fieldname/description/div"/>
									</div>
								</xsl:if>
							</div>
							<div class="clearfix"/>

						</xsl:otherwise>
					</xsl:choose>

				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
