var nobossapiimportermanual = {};

nobossapiimportermanual.CONSTRUCTOR = function () {
    // Botao de importacao
    var btnImporter = jQuery('.noboss-modal [data-importer="btn"]');
    // Alias da api
    var apiAlias = jQuery(btnImporter).parent().attr('data-api');
    // Input com data inicial
    var inputDtInicial = jQuery(btnImporter).parent().find('[data-importer="dt-initial"]');
    // Input com data final
    var inputDtFinal = jQuery(btnImporter).parent().find('[data-importer="dt-final"]');
    // Elemento para mensagem de api nao conectada
    var elMsgNotConnected = jQuery(btnImporter).parent().find('[data-importer="msg-not-connected"]');
    // Elemento para mensagens de erro
    var elMsgError = jQuery(btnImporter).parent().find('[data-importer="msg-error"]');
    // Elemento para mensagens de sucesso
    var elMsgSuccess = jQuery(btnImporter).parent().find('[data-importer="msg-success"]');

    // Aplica markara nos inputs de data
    jQuery(inputDtInicial).mask('0000-00-00');
    jQuery(inputDtFinal).mask('0000-00-00');

    // Evento de clique no botao de importacao
    btnImporter.on('click', function (){
        // Data inicial ou final nao informadas
        if((inputDtInicial.val().length < 10) || (inputDtFinal.val().length < 10)){
            // Exibe mensagem de erro
            elMsgError.html('Dates are invalid').css('display', 'block');
        }
        // Executa funcao de importacao
        else{
            // Esconde mensagem de erro
            jQuery(elMsgError).css('display', 'none');

            // Executa funcao de importacao
            nobossapiimportermanual.getApiManualImportAjax(inputDtInicial, inputDtFinal, elMsgError, elMsgNotConnected, elMsgSuccess, btnImporter, apiAlias);
        }
    });

    // Quando ocorrer alteracao no status de conexao
    jQuery('body').on('change', '[data-api-status]', function () {
        // Obtem status da api
        var statusApi = jQuery(this).attr('data-api-status');

        // API conectada
        if(statusApi == 1){
            // Desbloqueia inputs de data e botao
            jQuery(inputDtInicial).prop('disabled', false);
            jQuery(inputDtFinal).prop('disabled', false);
            jQuery(btnImporter).removeAttr('disabled');

            // Esconde mensagem de nao conectada api e/ou de erro (caso definidas)
            jQuery(elMsgNotConnected).css('display', 'none');
            jQuery(elMsgError).css('display', 'none');
        }
        // API nao conectada
        else{
            // Bloqueia inputs de data e botao
            jQuery(inputDtInicial).prop('disabled', true);
            jQuery(inputDtFinal).prop('disabled', true);
            jQuery(btnImporter).attr('disabled', 'disabled');
            
            // Exibe a mensagem de api nao conectada
            jQuery(elMsgNotConnected).css('display', 'block');
        }
    });

    
    // Forca atualizacao do status de conexao para '1'
    //jQuery('[data-api-status]').attr('data-api-status', 1).trigger('change');
};

jQuery(document).ready(function (jQuery) {
    nobossapiimportermanual.CONSTRUCTOR();
});

/**
 * Realiza a importacao manual dos dados
 */
nobossapiimportermanual.getApiManualImportAjax = function(inputDtInicial, inputDtFinal, elMsgError, elMsgNotConnected, elMsgSuccess, btnImporter, apiAlias){
    // Obtem os dados de conexao da api que estao em campo hidden
    var dataApiConnection = JSON.parse(jQuery('[data-id="apiconnection_hidden"]').val());

    // Dados de conexao nao estao definidos
    if(dataApiConnection == undefined || dataApiConnection.access_token == undefined){
        return;
    }

    // Esconde mensagem de sucesso, caso esteja exibida
    jQuery(elMsgSuccess).css('display', 'none');

    // Api nao esta conectada
    if(jQuery('[data-api-status]').attr('data-api-status') != '1'){
        jQuery('[data-schedule="msg-not-connected"]').css('display', 'block');
        return;
    }

    // Exibe loader ao lado do botao de importar
    jQuery(btnImporter).after(jQuery('<div class="loader loader--side"></div>'));

    var rules = {};

    // Percorre os campos de regras que sao do tipo radio
    jQuery(btnImporter).closest('.noboss-modal').find("input[name*='rules_']:checked").each(function() {
        // Extrai o name especifico do campo (Ex: 'import_description')
        var aliasField = jQuery(this).attr('name').split(/\[(.*?)\]/)[1].replace('rules[', '').replace('rules_', '');
        // Adiciona item no array
        rules[aliasField] = jQuery(this).val();
    });

    // Percorre os campos de regras que sao do tipo select
    jQuery(btnImporter).closest('.noboss-modal').find("select[name*='rules_'] option:selected").each(function() {
        // Extrai o name especifico do campo
        var aliasField = jQuery(this).parent().attr('name').split(/\[(.*?)\]/)[1].replace('rules[', '').replace('rules_', '');
        // Adiciona item no array
        rules[aliasField] = jQuery(this).val();
    });

    // Salva o campo especifico de 'limit de caracteres'
    rules['subtitle_limit'] = jQuery(btnImporter).closest('.noboss-modal').find("input[name*='rules_subtitle_limit']").val();    

    var idModule = 0;
    if(window.location.href.split("id=")[1] !== undefined){
        idModule = window.location.href.split("id=")[1].split("&")[0];
    }

    // Monta a url de requisição
    var request = {
        'option': 'com_nobossajax',
        'module': 'nobosscalendar',
        'method': 'apiImportManual',
        'format': 'raw'
    };

    // Monta os dados a serem enviados
    var data = {
        'params_api': encodeURIComponent(JSON.stringify(dataApiConnection)),
        'schedules': jQuery('[data-schedule="input"]').val(), // agendas selecionadas
        'rules': JSON.stringify(rules), // campos a serem importados
        'id_calendar': jQuery('input[name$="\\[id_calendar\\]"]').val(),
        'id_calendar_original': jQuery('input[name$="\\[id_calendar\\]"]').attr('id_calendar_original'),
        'id_module':  idModule,
        'start_date': inputDtInicial.val(),
        'final_date': inputDtFinal.val(),
        'api': apiAlias
    };

    // Coloca timeout para que loader seja exibido antes de 'travar' a pagina
    setTimeout(function () {
        // Executa requisicao ajax
        jQuery.ajax({
            url: baseNameUrl+ "administrator/index.php?" + jQuery.param(request),
            type: "POST",
            dataType: 'JSON',
            async: false,
            data: data,
            //Ocorreu algum erro
            error: function(jqXHR, textStatus, errorThrown) {
                throw new nobossapiimportermanual.errorMessage('Error: '+errorThrown, elMsgError);
            },
            beforeSend: function( xhr ) {
                xhr.overrideMimeType( "text/plain; charset=x-user-defined" );
            }
        }).done(function (result) {
            // Retorno ocorreu com sucesso
            if(result.success == 1){
                // Exibe mensagem de sucesso
                jQuery(elMsgSuccess).css('display', 'block');

                // Esconde mensagem de nao conectada api e/ou de erro (caso definidas)
                jQuery(elMsgNotConnected).css('display', 'none');
                jQuery(elMsgError).css('display', 'none');

                // Limpa campos de datas
                jQuery(inputDtInicial).val('');
                jQuery(inputDtFinal).val('');

                // Coloca a data da importacao retornada no input que salva no banco e no span que exibe
                jQuery(btnImporter).parent().find('[data-importer="last-date-display"]').html(result.date);
                jQuery(btnImporter).parent().find('[data-importer="last-date-input"]').val(result.date);
            }
            // Ocorreu algum erro
            else{
                // Exibe mensagem retornada de erro
                jQuery(elMsgError).html('Error: '+result.message).css('display', 'block');
            }

            // Remove o loader
            jQuery('body').find('.loader.loader--side').remove();
        });
    }, 200);
}

/**
 * Funcao para tratamento de erro
 */
nobossapiimportermanual.errorMessage = function(message, elMsgError){
    jQuery(elMsgError).html(message).css('display', 'block');
    // Remove o loader
    jQuery('body').find('.loader.loader--side').remove();
};
