var nobossapischedule = {};

nobossapischedule.CONSTRUCTOR = function () {
    // Obtem o select da agenda
    var select = jQuery('.noboss-modal [data-schedule="select"]');
    // Obtem o input que guarda os values da agenda
    var input = jQuery('.noboss-modal [data-schedule="input"]');
    // Alias da api
    var apiAlias = jQuery('.noboss-modal [data-api]').attr('data-api');

    // Joomla 3
    if(majorVersionJoomla !== undefined && majorVersionJoomla == '3'){
        // Sobreescreeve evento chosen (que ativa select diferente) p/ tratar o uso de 'readonly' de forma que o select possa ficar desabilitado sem que deixe de salvar o item que estiver selecionado
        select.on('chosen:updated', function () {
            if (select.attr('readonly')) {
                var wasDisabled = select.is(':disabled');
        
                select.attr('disabled', 'disabled');
                select.data('chosen').search_field_disabled();
        
                if (wasDisabled) {
                    select.attr('disabled', 'disabled');
                } else {
                    select.removeAttr('disabled');
                }
            }
        });
    }
    
    // Evento de alteracao no select de agenda
    select.on('change', function (){
        // Array para guardar items selecionados
        var selecteds = [];

        // Percorre todos itens selecionados
        jQuery(this).find('option:selected').each(function() {
            // Adiciona valor no array
            selecteds.push($(this).val());
        });

        // Converte o array para um json
        selecteds = JSON.stringify(selecteds);
        // Adiciona 'escape' (\) nas aspas

        // Salva json de itens selecionados no input
        input.val(selecteds);
    });

    // Quando ocorrer alteracao no status de conexao
    jQuery('body').on('change', '.noboss-modal [data-api-status]', function () {
        // Obtem status da api
        var statusApi = jQuery(this).attr('data-api-status');

        // API conectada
        if(statusApi == 1){
            // Busca agendas na api e atualiza select
            nobossapischedule.getApiSchedulesAjax(select, input, apiAlias);
        }
        // API nao conectada
        else{
            // Desabilita select
            select.attr('readonly', true).trigger('chosen:updated');

            // Exibe a mensagem de api nao conectada
            jQuery('.noboss-modal [data-schedule="msg-not-connected"]').css('display', 'block');
        }
    });

};

jQuery(document).ready(function (jQuery) {
    nobossapischedule.CONSTRUCTOR();
});

/**
 * Obtem as agendas de uma conta da api e atualiza select html
 */
nobossapischedule.getApiSchedulesAjax = function(select, input, apiAlias){
    // Obtem os dados de conexao da api que estao em campo hidden
    var dataApiConnection = JSON.parse(jQuery('.noboss-modal [data-id="apiconnection_hidden"]').val());

    if(dataApiConnection == undefined || dataApiConnection.access_token == undefined, dataApiConnection.refresh_token == undefined){
        return;
    }

    // Monta a url de requisição
    var request = {
        'option': 'com_nobossajax',
        'module': 'nobosscalendar',
        'method': 'apiGetSchedules',
        'format': 'raw'
    };

    // Monta os dados a serem enviados
    var data = {
        'client_id': dataApiConnection.client_id,
        'client_secret': dataApiConnection.client_secret,
        'access_token': dataApiConnection.access_token,
        'refresh_token': dataApiConnection.refresh_token,
        'api': apiAlias
    };

    // Executa requisicao ajax
    jQuery.ajax({
        url: baseNameUrl+ "administrator/index.php?" + jQuery.param(request),
        type: "POST",
        dataType: 'JSON',
        async: false,
        data: data,
        error: function(jqXHR, textStatus, errorThrown) {
            throw new nobossapischedule.errorMessage('Error: '+errorThrown);
        }
    }).done(function (result) {
        // Retorno ocorreu com sucesso
        if((result.success !== undefined) && (result.success === 1)){
            // Remove os options que existem atualmente
            select.empty();

            // Percorre as agendas retornadas para gerar options
            jQuery.each(result.items, function (i, schedule) {
                var summary = '';
                if(schedule.summaryOverride !== undefined){
                    summary = schedule.summaryOverride;
                }
                else{
                    summary = schedule.summary;
                }

                select.append('<option value='+schedule.id+'>'+summary+'</option>');
            });

            // Havia alguma agenda selecionada anteriormente
            if ((input.val() != '')){
                // Converte o valor do input de json para um objeto
                var schedulesSelected = JSON.parse(input.val());

                // Percorre as agendas salvas no input para selecionar no select
                jQuery.each(schedulesSelected, function (i, scheduleSelected) {
                    select.children('option[value="'+scheduleSelected+'"]').attr('selected','selected');
                });
            }

            // Joomla 3
            if(majorVersionJoomla !== undefined && majorVersionJoomla == '3'){
                // Atualiza o chosen de acordo com o novo select
                select.trigger('liszt:updated');
            }

            // Habilita select
            select.attr('readonly', false).trigger('chosen:updated');
            
            // Esconde mensagem de nao conectada api e/ou de erro (caso definidas)
            jQuery('.noboss-modal [data-schedule="msg-not-connected"]').css('display', 'none');
            jQuery('.noboss-modal [data-schedule="msg-error"]').css('display', 'none');
        }
        // Ocorreu algum erro
        else{
            // Exibe mensagem retornada de erro
            jQuery('.noboss-modal [data-schedule="msg-error"]').html('Error: '+result.message).css('display', 'block');
        }
    });
}

/**
 * Funcao para tratamento de erro
 */
nobossapischedule.errorMessage = function(message){
    // Exibe mensagem retornada de erro
    jQuery('.noboss-modal [data-schedule="msg-error"]').html(message).css('display', 'block');
};
