<?php
/**
 * @package			No Boss Extensions
 * @subpackage  	No Boss Calendar
 * @author			No Boss Technology <contact@nobosstechnology.com>
 * @copyright		Copyright (C) 2021 No Boss Technology. All rights reserved.
 * @license			GNU Lesser General Public License version 3 or later; see <https://www.gnu.org/licenses/lgpl-3.0.en.html>
 */

defined('_JEXEC') or die();

/*
 * Classe para requisicoes de categories
 */
trait ModNobosscalendarHelperCategories {
    /**
	 * Obtem categorias via Ajax para area admin
	 *
	 * @return  void
	 */
    public static function getCategoriesAjax(){
        header('Access-Control-Allow-Origin: *');
        error_reporting(0);

        $idCalendar = JFactory::getApplication()->input->get("id_calendar", '', 'STRING');

        $response = array();
        
        try{
            // Obtem as categorias
            $response['categories'] = self::getCategories($idCalendar, '', 'manual');
            $response['success'] = 1;
        }
        catch(Exception $e){
            $response['success'] = 0;
            $response['error'] = $e->getMessage();
        }
        
        // Retorna a resposta em json
        exit(json_encode($response));
    }

    /**
	 * Salva categorias no banco de dados via Ajax
	 *
	 */
    public static function saveCategoriesAjax(){
        header('Access-Control-Allow-Origin: *');
        error_reporting(0);

        $input = JFactory::getApplication()->input;
        $idCalendar = $input->get("id_calendar", '', 'STRING');
        $idCalendarOriginal = $input->get("id_calendar_original", '', 'STRING');
        $categories = $input->get("categories", '', 'RAW');

        $response = array();

        // echo '<pre>';
        // var_dump($categories);
        // exit;
        
        try{
            // Salva as categorias
            self::updateCategoriesCalendar($idCalendar, $idCalendarOriginal, $categories);
            $response['success'] = 1;
        }
        catch(Exception $e){
            $response['success'] = 0;
            $response['error'] = $e->getMessage();
        }
        
        // Retorna a resposta em json
        exit(json_encode($response));
    }
    
    /**
	 * Obtem categorias
     * 
     * @param   String    $idCalendar 	        Id do calendario (obrigatorio)
     * @param   String    $idCategorie 	        Id do modulo (opcional, se definido o id do calendario)
     * @param   String    $inputType 	        Tipo de categoria ('manual', 'googlecalendar') - deixar em branco para pegar todas
	 *
	 * @return  void      Quando passado $idCategorie retorna um objeto, caso contrario retorna array de objetos
	 */
    public static function getCategories($idCalendar, $idCategorie = '', $inputType = ''){
        $db = JFactory::getDBO();
        $query = $db->getQuery(true);

        $query->select("id_categorie AS id, legend, category_color, show_in_legends");
        $query->from($db->quoteName('#__noboss_calendar_categories', 'curso'));
        $query->where('id_calendar =' . $db->quote($idCalendar));

        if(!empty($inputType)){
            $query->where('input_type =' . $db->quote($inputType));
        }
                
        // Foi enviada o id de categoria: retorna objeto com resultado
        if(!empty($idCategorie)){
            $query->where('id_categorie =' . $db->quote($idCategorie));
            $db->setQuery($query);
            return $db->loadObject();
        }
        // Retorna array de objeto com todos resultados para o id_calendar
        else{
            $db->setQuery($query);
            return $db->loadObjectList();
        }
    }

    /**
	 * Remove as categorias de um id de calendario e salva as novas recebidas por parametro
     * 
     * @param   String    $idCalendar 	        Id do calendario
     * @param   String    $idCalendarOriginal 	Id do calendario antes da edicao (para caso usuario tenha alterado)
     * @param   Array     $categories 	        Categorias a salvar
     * @param   String    $inputType 	        Tipo de categoria ('manual', 'googlecalendar')
	 *
	 */
    public static function updateCategoriesCalendar($idCalendar, $idCalendarOriginal, $categories, $inputType = 'manual'){
        $db = JFactory::getDBO();
        
        try{
            // Remove as categorias que existentes do id de calendario
            self::deleteCategories($idCalendarOriginal, $inputType);
            
            // Insere as categorias recebidas por parametro
            foreach ($categories as $categorie) {
                $categorie = (object)$categorie;
                
                // Salva a categoria no banco
                self::saveCategorie($idCalendar, $categorie, $inputType);
            }
        }
        catch(Exception $e){
            $e->getMessage();
        }
    }

    /**
	 * Salva uma categoria especifica
     * 
     * @param   String    $idCalendar 	        Id do calendario
     * @param   oBJECT    $categorie 	        Objeto com os dados da categoria
     * @param   String    $inputType 	        Tipo de categoria ('manual', 'googlecalendar')
	 *
	 */
    public static function saveCategorie($idCalendar, $categorie, $inputType = 'manual'){
        $db = JFactory::getDBO();

        // Tratamento de conflito que pode ocorrer qnd vem o nome do id
        if(!empty($categorie->id_categorie) && empty($categorie->id)){
            $categorie->id = $categorie->id_categorie;
        }
        
        try{
            $categorie = (object)$categorie;
            $query = $db->getQuery(true);
            $columns = array('id_categorie', 'id_calendar', 'legend', 'category_color', 'show_in_legends', 'input_type');
            $values = array($db->quote($categorie->id), $db->quote($idCalendar), $db->quote($categorie->legend), $db->quote($categorie->category_color), $db->quote($categorie->show_in_legends), $db->quote($inputType));

            // Realiza insert no banco
            $query->insert($db->quoteName('#__noboss_calendar_categories'))
            ->columns($db->quoteName($columns))
            ->values(implode(',', $values));

            //echo str_replace('#__', 'ext_', $query); exit;

            $db->setQuery($query);
            $db->execute();
        }
        catch(Exception $e){
            $e->getMessage();
        }
    }

    /**
	 * Remove categorias de um id de calendario
     * 
     * @param   String      $idCalendar 	Id do calendario (opcional, se informado idModule)
     * @param   String      $inputType 	        Tipo de categoria ('manual', 'googlecalendar')
	 *
	 * @return  Mixed       True ou false
	 */
    private static function deleteCategories($idCalendar, $inputType = "manual"){
        $db = JFactory::getDBO();
        $query = $db->getQuery(true);

        $query->delete('#__noboss_calendar_categories')
            ->where('id_calendar =' . $db->quote($idCalendar))
            ->where('input_type =' . $db->quote($inputType));

       //echo str_replace('#__', 'ext_', $query); exit;

        try {
            $db->setQuery($query);
            $db->execute();
        } catch (Exception $e) {
            return false;
        }
    }
}
