<?php
/**
 * @package			No Boss Extensions
 * @subpackage  	No Boss Calendar
 * @author			No Boss Technology <contact@nobosstechnology.com>
 * @copyright		Copyright (C) 2022 No Boss Technology. All rights reserved.
 * @license			GNU Lesser General Public License version 3 or later; see <https://www.gnu.org/licenses/lgpl-3.0.en.html>
 */

defined('_JEXEC') or die();
// Importa os arquivos da library noboss
jimport('noboss.util.loadextensionassets');
// Define prefixo a ser utilizado na insercao de codigos inline para CSS e JS
$prefixCodeJsAndCss = "[module-id={$moduleName}_{$idModule}]";
// Instancia objeto passando o nome da extensao com prefixo (ex: 'mod_nobossbanners')
$assetsObject = new NoBossUtilLoadExtensionAssets($extensionName, $prefixCodeJsAndCss);
?>
<div class="nb-calendar__header">   
    <nav class="nb-header-controls" style="<?php echo $custom->month_header_space; ?>">
        <?php
        // Modelo 3 OU modelo 2
        if(($theme == 'model3') || ($theme == 'model2')){ 
            // OBS: Qnd for modelo 2 (cards) e nao houver eventos para esquerda, adiciona classe css que desabilita botao
           ?>
            <a class="nb-calendar-controls nb-left <?php echo (($theme == 'model2') && (isset($returnEventsCards->show_navigation_prev)) && ($returnEventsCards->show_navigation_prev == 0)) ? 'nb-controls-disabled' : ''; ?>" href="#" role="button" data-slide="prev">
                <span class="nb-arrows fa <?php echo (!empty($custom->arrows_icon)) ? str_replace('DIRECTION', 'left', $custom->arrows_icon) : '';  ?>" style="<?php echo $custom->arrows_style; ?>"></span>    
                <span class="hidden">prev</span>
            </a>
        <?php 
        }
        ?>
        <div class="nb-calendar__date" style="<?php echo $custom->month_header_style; ?>">
            <?php
            // Modelo nao eh o 2 (cards) OU eh cards e parametro de navegacao por mes nao esta definido (default eh exibir) OU parametro esta setado para exibir mes
            if(($theme != 'model2') || (!isset($custom->browsing_month)) || ($custom->browsing_month == 1)){
                // Exibe o mes em formato de string
                $currentMonth = ModNobosscalendarHelper::getMonthString($date->month);

                if($theme != 'model1'){
                    $currentMonth .= ', ' . $date->year;
                }
                if(empty($custom->month_header_font_family)){
                    $custom->month_header_font_family = 'font-family: inherit;';
                }

                if(empty($custom->month_header_color)){
                    $custom->month_header_color = "inherit";
                }
               
                // Exibe mes que esta sendo navegado
                echo "<{$custom->month_header_tag_html} class='month-header-title' >{$currentMonth}</{$custom->month_header_tag_html}>";
            }
            ?>
        </div>
        <?php
        // Modelo 3 OU modelo 2
        if(($theme == 'model3') || ($theme == 'model2')){  
            // OBS: Qnd for modelo 2 (cards) e nao houver eventos para direita, adiciona classe css que desabilita botao
            ?>
            <a class="nb-calendar-controls nb-right <?php echo (($theme == 'model2') && (isset($returnEventsCards->show_navigation_next)) && ($returnEventsCards->show_navigation_next == 0)) ? 'nb-controls-disabled' : ''; ?>" href="#" role="button" data-slide="next">
                <span class="nb-arrows fa <?php echo (!empty($custom->arrows_icon)) ? str_replace('DIRECTION', 'right', $custom->arrows_icon) : '';  ?>" style="<?php echo $custom->arrows_style; ?>"></span>    
                <span class="hidden">next</span>
            </a>
            <?php
        } ?>
    </nav>

</div>

<?php 
require JModuleHelper::getLayoutPath($extensionName, 'style/month_header');
?>
