<?php
/**
 * @package			No Boss Extensions
 * @subpackage  	No Boss Calendar
 * @author			No Boss Technology <contact@nobosstechnology.com>
 * @copyright		Copyright (C) 2022 No Boss Technology. All rights reserved.
 * @license			GNU Lesser General Public License version 3 or later; see <https://www.gnu.org/licenses/lgpl-3.0.en.html>
 */
 
defined('_JEXEC') or die();
?>
<div class="nb-sidebar" data-now='<?php echo $date; ?>' style='<?php echo "color: {$custom->sidebar_text_color};"; ?>'>
    <div class="nb-sidebar__header" style="<?php echo $custom->year_header_spacing; ?>">   
        <nav class="nb-header-controls">
            <a class="nb-calendar-controls nb-left" href="#" role="button" data-slide="prev" title="Visualizar anterior">
                <span class="nb-arrows fa <?php echo (!empty($custom->arrows_icon)) ? str_replace('DIRECTION', 'left', $custom->arrows_icon) : '';  ?>" style="<?php echo $custom->arrows_style; ?>"></span>    
                <span class="hidden">prev</span>
            </a>
            <div class="nb-calendar__date" style="text-align: center;">
                <?php
                    echo "<{$custom->year_header_tag_html} style='{$custom->year_header_size}'>{$date->year}</{$custom->year_header_tag_html}>";
                ?>
            </div>
            <a class="nb-calendar-controls nb-right" href="#" role="button" data-slide="next" title="Visualizar próximo">
                <span class="nb-arrows fa <?php echo (!empty($custom->arrows_icon)) ? str_replace('DIRECTION', 'right', $custom->arrows_icon) : '';  ?>" style="<?php echo $custom->arrows_style; ?>"></span>    
                <span class="hidden">next</span>
            </a>
        </nav>
    </div>
    <div class="nb-sidebar__months">
        <?php 
        // Percorre todos os meses do ano para exibir em lista
        foreach ($yearMonths as $dateMonth => $events) { 
            $dateMonth = JDate::getInstance($dateMonth);
            $isActive = (!empty($today)) && ($today->month == $dateMonth->month && $today->year == $dateMonth->year) ? "is-active" : ""; ?>
            <div class="nb-sidebar__month <?php echo $isActive; ?>" data-month="<?php echo $dateMonth->month; ?>" data-month-date="<?php echo $dateMonth; ?>">
                <a href="http://" class="nb-sidebar__link" style="<?php echo $custom->sidebar_months_spacing; ?> <?php echo "color: {$custom->sidebar_text_color};"; ?>">
                    <div class="month-header-title" style='<?php echo $custom->sidebar_months_size; ?>'><?php $dateMonth = JDate::getInstance($dateMonth);
                    // Exibe o mes em formato de string
                    echo ModNobosscalendarHelper::getMonthString($dateMonth->month);
                    ?>
                    </div>
                    <?php if($events > 0){ ?>
                        <span class="nb-sidebar__events-number" style='<?php echo "color: {$custom->sidebar_background_color};"; ?> <?php echo "background-color: {$custom->sidebar_text_color};" ?> <?php echo $custom->sidebar_months_bullet_size; ?> <?php echo $custom->sidebar_months_bullet_width; ?> '><?php echo $events; ?></span>
                    <?php } ?>
                </a>
            </div>
        <?php 
        }
        ?>
    </div>
</div>
